
function PrintError ($message) {
   Write-Host $message -ForegroundColor Red -BackgroundColor Black
}

function AddVPNConnection () {
  try {
    Add-VpnConnection -Name 'Kline IKEv2' -ServerAddress '149.154.2.55' -TunnelType 'IKEv2' -EncryptionLevel 'Required' -AuthenticationMethod Eap  -DnsSuffix ad.klineelectric.com -RememberCredential 
    Set-VpnConnectionIPsecConfiguration -ConnectionName 'Kline IKEv2' -AuthenticationTransformConstants 'SHA196' -CipherTransformConstants 'AES256' -DHGroup 'Group14' -EncryptionMethod 'AES256' -IntegrityCheckMethod 'SHA256' -PfsGroup 'None' -Force
    Write-Host "Created the 'Kline IKEv2' VPN connection"
  }   catch {
    PrintError "Error in creating the 'Kline IKEv2' VPN connection!" 
    PrintError $_.Exception.Message
  }
}

$vpn = Get-VpnConnection -Name 'Kline IKEv2' -ErrorAction SilentlyContinue
if ($vpn -and ($vpn.Name -eq 'Kline IKEv2')) {
  PrintError "A VPN connection with the name 'Kline IKEv2' is already configured on your system."
  $message = "Do you want to update the existing 'Kline IKEv2' VPN connection?"
  $yes = New-Object System.Management.Automation.Host.ChoiceDescription "&Yes", "Updates the 'Kline IKEv2' VPN connection."
  $no = New-Object System.Management.Automation.Host.ChoiceDescription "&No", "Exit without updating."
  $options = [System.Management.Automation.Host.ChoiceDescription[]]($yes, $no)
  $result = $host.ui.PromptForChoice('', $message, $options, 0)
  switch ($result) {
    0 {Remove-VpnConnection -Name 'Kline IKEv2' -Force}
    1 {
      PrintError "The existing Kline IKEv2 VPN connection was not updated. Remove or rename the existing VPN connection and run the script again.";
      exit
    }
  }
}

AddVPNConnection
exit

